/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class ItemListDisplaySource extends Internal.ValueListDisplaySource {
        constructor()
    }
    type ItemListDisplaySource_ = ItemListDisplaySource;
    class DarkOakTrunkPlacer extends Internal.TrunkPlacer {
        constructor($$0: number, $$1: number, $$2: number)
        static readonly CODEC: Internal.Codec<Internal.DarkOakTrunkPlacer>;
    }
    type DarkOakTrunkPlacer_ = DarkOakTrunkPlacer;
    class RecipeKey <T> {
        constructor(component: Internal.RecipeComponent_<T>, name: string)
        optional(value: T): this;
        preferred(name: string): this;
        defaultOptional(): this;
        optional(): boolean;
        optional(value: Internal.RecipeOptional_<T>): this;
        alt(...names: string[]): this;
        includeInAutoConstructors(): boolean;
        exclude(): this;
        alt(name: string): this;
        alwaysWrite(): this;
        allowEmpty(): this;
        noBuilders(): this;
        readonly name: string;
        excluded: boolean;
        preferred: string;
        alwaysWrite: boolean;
        optional: Internal.RecipeOptional<T>;
        readonly names: Internal.Set<string>;
        allowEmpty: boolean;
        readonly component: Internal.RecipeComponent<T>;
        noBuilders: boolean;
    }
    type RecipeKey_<T> = RecipeKey<T>;
    class ModifierRemovalRecipe$Serializer extends Internal.LoggingRecipeSerializer<Internal.ModifierRemovalRecipe> {
        constructor(factory: any_)
        constructor(factory: any_)
        toNetworkSafe(buffer: Internal.FriendlyByteBuf_, recipe: Internal.ModifierRemovalRecipe_): void;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetworkSafe(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.ModifierRemovalRecipe;
        toNetworkSafe(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
    }
    type ModifierRemovalRecipe$Serializer_ = ModifierRemovalRecipe$Serializer;
    interface RandomSource {
        create($$0: number): this;
        abstract fork(): this;
        create(): this;
        abstract nextBoolean(): boolean;
        abstract nextLong(): number;
        abstract setSeed(arg0: number): void;
        abstract nextDouble(): number;
        nextInt($$0: number, $$1: number): number;
        abstract nextGaussian(): number;
        createNewThreadLocalInstance(): this;
        consumeCount($$0: number): void;
        abstract forkPositional(): Internal.PositionalRandomFactory;
        triangle($$0: number, $$1: number): number;
        abstract nextInt(arg0: number): number;
        abstract nextFloat(): number;
        /**
         * @deprecated
        */
        createThreadSafe(): this;
        abstract nextInt(): number;
        nextIntBetweenInclusive($$0: number, $$1: number): number;
        set seed(arg0: number)
        /**
         * @deprecated
        */
        readonly GAUSSIAN_SPREAD_FACTOR: 2.297;
    }
    type RandomSource_ = RandomSource;
    interface HandledScreenAccessor {
        abstract getTouchDragStack(): Internal.ItemStack;
        abstract getTouchDragSlotStart(): Internal.Slot;
        abstract invokeCalculateOffset(): void;
        abstract getTouchIsRightClickDrag(): boolean;
        abstract getHeldButtonType(): number;
        get touchDragStack(): Internal.ItemStack
        get touchDragSlotStart(): Internal.Slot
        get touchIsRightClickDrag(): boolean
        get heldButtonType(): number
    }
    type HandledScreenAccessor_ = HandledScreenAccessor;
    interface IStorageMounts {
        abstract mount(arg0: Internal.MEStorage_, arg1: number): void;
        mount(inventory: Internal.MEStorage_): void;
        (arg0: Internal.MEStorage, arg1: number): void;
        readonly DEFAULT_PRIORITY: 0;
    }
    type IStorageMounts_ = IStorageMounts;
    interface ITinkerStationRecipe extends Internal.ICommonRecipe<Internal.ITinkerStationContainer> {
        getGroup(): string;
        getValidatedResult(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ValidatedResult;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        getRemainingItems(inv: Internal.ITinkerStationContainer_): Internal.NonNullList<Internal.ItemStack>;
        abstract matches(arg0: Internal.ITinkerStationContainer_, arg1: Internal.Level_): boolean;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        updateInputs(result: Internal.ItemStack_, inv: Internal.IMutableTinkerStationContainer_, isServer: boolean): void;
        abstract getId(): ResourceLocation;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        abstract getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<any>;
        shrinkToolSlotBy(): number;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        assemble(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        readonly DEFAULT_TOOL_STACK_SIZE: 16;
    }
    type ITinkerStationRecipe_ = ITinkerStationRecipe;
    abstract class CopycatBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.ExplosionResistanceBlock, Internal.BlockPickInteractionAware, Internal.EnchantmentBonusBlock, Internal.CustomFrictionBlock, Internal.LightEmissiveBlock, Internal.CustomSoundTypeBlock, Internal.IBE<Internal.CopycatBlockEntity>, Internal.CustomRunningEffectsBlock, Internal.ValidSpawnBlock, Internal.CustomLandingEffectsBlock {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        shouldFaceAlwaysRender(state: Internal.BlockState_, face: Internal.Direction_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        abstract canConnectTexturesToward(arg0: Internal.BlockAndTintGetter_, arg1: BlockPos_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getFriction(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_, entity: Internal.Entity_): number;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CopycatBlockEntity>;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        setDestroySpeed(v: number): void;
        getPickedStack(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_, result: Internal.HitResult_): Internal.ItemStack;
        static getMaterial(reader: Internal.BlockGetter_, targetPos: BlockPos_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CopycatBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        isValidSpawn(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, type: Internal.SpawnPlacements$Type_, entityType: Internal.EntityType_<any>): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.CopycatBlockEntity>;
        emi(): Internal.EmiStack;
        canFaceBeOccluded(state: Internal.BlockState_, face: Internal.Direction_): boolean;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        isIgnoredConnectivitySide(reader: Internal.BlockAndTintGetter_, state: Internal.BlockState_, face: Internal.Direction_, fromPos: BlockPos_, toPos: BlockPos_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        isAcceptedRegardless(material: Internal.BlockState_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CopycatBlockEntity>): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getExplosionResistance(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, explosion: Internal.Explosion_): number;
        setRequiresTool(v: boolean): void;
        getBlockEntityClass(): typeof Internal.CopycatBlockEntity;
        prepareMaterial(pLevel: Internal.Level_, pPos: BlockPos_, pState: Internal.BlockState_, pPlayer: Internal.Player_, pHand: Internal.InteractionHand_, pHit: Internal.BlockHitResult_, material: Internal.BlockState_): Internal.BlockState;
        getLightEmission(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_): number;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CopycatBlockEntity;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getEnchantPowerBonus(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_): number;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        static wrappedColor(): Internal.BlockColor;
        getAcceptedBlockState(pLevel: Internal.Level_, pPos: BlockPos_, item: Internal.ItemStack_, face: Internal.Direction_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        getSoundType(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_, entity: Internal.Entity_): SoundType;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.CopycatBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.CopycatBlockEntity
        get mod(): string
    }
    type CopycatBlock_ = CopycatBlock;
    class ContinuationFrame$Companion {
        fromNBT(tag: Internal.CompoundTag_, world: Internal.ServerLevel_): Internal.ContinuationFrame;
        toNBT(frame: Internal.ContinuationFrame_): Internal.CompoundTag;
    }
    type ContinuationFrame$Companion_ = ContinuationFrame$Companion;
    interface SkullSettings extends Internal.SkullData {
        abstract setInitialized(arg0: boolean): void;
        abstract initialized(): boolean;
        abstract setupHeadLayers(arg0: Internal.Mesh_): void;
        getMesh(): Internal.Mesh;
        abstract setLastTexture(arg0: ResourceLocation_): void;
        abstract getHeadLayers(): Internal.Mesh;
        abstract getLastTexture(): ResourceLocation;
        set initialized(arg0: boolean)
        set upHeadLayers(arg0: Internal.Mesh_)
        get mesh(): Internal.Mesh
        set lastTexture(arg0: ResourceLocation_)
        get headLayers(): Internal.Mesh
        get lastTexture(): ResourceLocation
    }
    type SkullSettings_ = SkullSettings;
    interface IProfilingServerFunctionManager {
        abstract mfix$getProfilingResults(): string;
        (): string;
    }
    type IProfilingServerFunctionManager_ = IProfilingServerFunctionManager;
    interface ITextureAtlasSpriteExtension {
        abstract getPixelRGBA(arg0: number, arg1: number, arg2: number): number;
        (arg0: number, arg1: number, arg2: number): number;
    }
    type ITextureAtlasSpriteExtension_ = ITextureAtlasSpriteExtension;
    interface CraftingContainer extends net.minecraft.world.Container, Internal.StackedContentsCompatible, Internal.CraftingContainerKJS {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        abstract isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        abstract getItems(): Internal.List<Internal.ItemStack>;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        abstract removeItem(arg0: number, arg1: number): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        abstract setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        abstract getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        abstract getHeight(): number;
        abstract setItem(arg0: number, arg1: Internal.ItemStack_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getMenu(): Internal.AbstractContainerMenu;
        abstract getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        abstract fillStackedContents(arg0: Internal.StackedContents_): void;
        abstract removeItemNoUpdate(arg0: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract stillValid(arg0: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        abstract getItem(arg0: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        abstract clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get items(): Internal.List<Internal.ItemStack>
        get slots(): number
        get containerSize(): number
        get height(): number
        get menu(): Internal.AbstractContainerMenu
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type CraftingContainer_ = CraftingContainer;
    interface NavigatingEntity {
        abstract setRegisteredToWorld(arg0: Internal.PathNavigation_): void;
        abstract getRegisteredNavigation(): Internal.PathNavigation;
        abstract updateNavigationRegistration(): void;
        abstract isRegisteredToWorld(): boolean;
        set registeredToWorld(arg0: Internal.PathNavigation_)
        get registeredNavigation(): Internal.PathNavigation
        get registeredToWorld(): boolean
    }
    type NavigatingEntity_ = NavigatingEntity;
    interface AbuseReportSender {
        abstract send(arg0: Internal.UUID_, arg1: Internal.AbuseReport_): Internal.CompletableFuture<com.mojang.datafixers.util.Unit>;
        create($$0: Internal.ReportEnvironment_, $$1: Internal.UserApiService_): this;
        reportLimits(): Internal.AbuseReportLimits;
        abstract isEnabled(): boolean;
        get enabled(): boolean
    }
    type AbuseReportSender_ = AbuseReportSender;
    class BlockEntityBuilder <T extends Internal.BlockEntity, P> extends Internal.AbstractBuilder<Internal.BlockEntityType<any>, Internal.BlockEntityType<T>, P, Internal.BlockEntityBuilder<T, P>> {
        onRegisterAfter<OR>(dependencyType: Internal.ResourceKey_<Internal.Registry<OR>>, callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<Internal.BlockEntityType<T>>): this;
        setData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: Internal.NonNullBiConsumer_<Internal.DataGenContext<Internal.BlockEntityType<any>, Internal.BlockEntityType<T>>, D>): this;
        addMiscData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<D>): this;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        static create<T extends Internal.BlockEntity, P>(owner: Internal.AbstractRegistrate_<any>, parent: P, name: string, callback: Internal.BuilderCallback_, factory: Internal.BlockEntityBuilder$BlockEntityFactory_<T>): Internal.BlockEntityBuilder<T, P>;
        get(): Internal.RegistryEntry<Internal.BlockEntityType<T>>;
        transform<R2, T2 extends R2, P2, S2 extends Internal.Builder<R2, T2, P2, S2>>(func: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.BlockEntityBuilder<T, P>, S2>): S2;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        lazy(): Internal.NonNullSupplier<Internal.RegistryEntry<T>>;
        renderer(renderer: Internal.NonNullSupplier_<com.tterrag.registrate.util.nullness.NonNullFunction<Internal.BlockEntityRendererProvider$Context, Internal.BlockEntityRenderer<T>>>): this;
        validBlock(block: Internal.NonNullSupplier_<Internal.Block>): this;
        validBlocks(...blocks: Internal.NonNullSupplier_<Internal.Block>[]): this;
        register(): Internal.RegistryEntry<any>;
        onRegister(callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<Internal.BlockEntityType<T>>): this;
        getEntry(): Internal.BlockEntityType<T>;
        build(): P;
        get entry(): Internal.BlockEntityType<T>
    }
    type BlockEntityBuilder_<T extends Internal.BlockEntity, P> = BlockEntityBuilder<T, P>;
    class RenderStateShard$TextureStateShard extends Internal.RenderStateShard$EmptyTextureStateShard implements Internal.TextureStateShardAccessor {
        constructor($$0: ResourceLocation_, $$1: boolean, $$2: boolean)
        port_lib$mipmap(arg0: boolean): void;
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        port_lib$blur(arg0: boolean): void;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        readonly texture: Internal.Optional<ResourceLocation>;
        blur: boolean;
        mipmap: boolean;
    }
    type RenderStateShard$TextureStateShard_ = RenderStateShard$TextureStateShard;
    interface SpecialLogicInventory {
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        abstract fabric_onFinalCommit(arg0: number, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_): void;
        abstract fabric_setSuppress(arg0: boolean): void;
    }
    type SpecialLogicInventory_ = SpecialLogicInventory;
    interface CoreGeoBone {
        saveSnapshot(): Internal.BoneSnapshot;
        abstract setHidden(arg0: boolean): void;
        updateScale(scaleX: number, scaleY: number, scaleZ: number): void;
        updatePosition(posX: number, posY: number, posZ: number): void;
        abstract getPivotY(): number;
        abstract setPivotY(arg0: number): void;
        abstract setPivotZ(arg0: number): void;
        abstract setRotZ(arg0: number): void;
        abstract getPivotZ(): number;
        abstract setRotX(arg0: number): void;
        abstract setRotY(arg0: number): void;
        abstract setPivotX(arg0: number): void;
        abstract getPivotX(): number;
        abstract getRotZ(): number;
        abstract hasRotationChanged(): boolean;
        abstract getRotX(): number;
        abstract getRotY(): number;
        abstract getName(): string;
        updatePivot(pivotX: number, pivotY: number, pivotZ: number): void;
        abstract setPosX(arg0: number): void;
        abstract setScaleX(arg0: number): void;
        abstract resetStateChanges(): void;
        abstract setScaleZ(arg0: number): void;
        abstract setScaleY(arg0: number): void;
        abstract getInitialSnapshot(): Internal.BoneSnapshot;
        abstract hasPositionChanged(): boolean;
        updateRotation(xRot: number, yRot: number, zRot: number): void;
        abstract setChildrenHidden(arg0: boolean): void;
        abstract isHidden(): boolean;
        abstract setPosY(arg0: number): void;
        abstract getParent(): this;
        abstract setPosZ(arg0: number): void;
        abstract getPosX(): number;
        abstract getPosY(): number;
        abstract getPosZ(): number;
        abstract markPositionAsChanged(): void;
        abstract getChildBones(): Internal.List<Internal.CoreGeoBone>;
        abstract markRotationAsChanged(): void;
        abstract hasScaleChanged(): boolean;
        abstract saveInitialSnapshot(): void;
        abstract isHidingChildren(): boolean;
        abstract markScaleAsChanged(): void;
        abstract getScaleY(): number;
        abstract getScaleZ(): number;
        abstract getScaleX(): number;
        set hidden(arg0: boolean)
        get pivotY(): number
        set pivotY(arg0: number)
        set pivotZ(arg0: number)
        set rotZ(arg0: number)
        get pivotZ(): number
        set rotX(arg0: number)
        set rotY(arg0: number)
        set pivotX(arg0: number)
        get pivotX(): number
        get rotZ(): number
        get rotX(): number
        get rotY(): number
        get name(): string
        set posX(arg0: number)
        set scaleX(arg0: number)
        set scaleZ(arg0: number)
        set scaleY(arg0: number)
        get initialSnapshot(): Internal.BoneSnapshot
        set childrenHidden(arg0: boolean)
        get hidden(): boolean
        set posY(arg0: number)
        get parent(): Internal.CoreGeoBone
        set posZ(arg0: number)
        get posX(): number
        get posY(): number
        get posZ(): number
        get childBones(): Internal.List<Internal.CoreGeoBone>
        get hidingChildren(): boolean
        get scaleY(): number
        get scaleZ(): number
        get scaleX(): number
    }
    type CoreGeoBone_ = CoreGeoBone;
    interface ReadableContainerExtended <T> {
        clone<T>(container: Internal.PalettedContainerRO_<T>): Internal.PalettedContainerRO<T>;
        abstract sodium$unpack(arg0: T[]): void;
        of<T>(container: Internal.PalettedContainerRO_<T>): this;
        abstract sodium$unpack(arg0: T[], arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
        abstract sodium$copy(): Internal.PalettedContainerRO<T>;
    }
    type ReadableContainerExtended_<T> = ReadableContainerExtended<T>;
    interface ItemCopyingRecipe$SupportsItemCopying {
        canCopyFromItem(item: Internal.ItemStack_): boolean;
        createCopy(original: Internal.ItemStack_, count: number): Internal.ItemStack;
        canCopyToItem(item: Internal.ItemStack_): boolean;
    }
    type ItemCopyingRecipe$SupportsItemCopying_ = ItemCopyingRecipe$SupportsItemCopying;
    interface MenuType$MenuSupplier <T extends Internal.AbstractContainerMenu> {
        abstract create(arg0: number, arg1: Internal.Inventory_): T;
        (arg0: number, arg1: Internal.Inventory): T;
    }
    type MenuType$MenuSupplier_<T extends Internal.AbstractContainerMenu> = MenuType$MenuSupplier<T>;
    interface CauldronInteraction {
        fillBucket($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.Player_, $$4: Internal.InteractionHand_, $$5: Internal.ItemStack_, $$6: Internal.ItemStack_, $$7: Internal.Predicate_<Internal.BlockState>, $$8: Internal.SoundEvent_): Internal.InteractionResult;
        bootStrap(): void;
        newInteractionMap(): Internal.Object2ObjectOpenHashMap<Internal.Item, Internal.CauldronInteraction>;
        addDefaultInteractions($$0: Internal.Map_<Internal.Item, Internal.CauldronInteraction>): void;
        emptyBucket($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.Player_, $$3: Internal.InteractionHand_, $$4: Internal.ItemStack_, $$5: Internal.BlockState_, $$6: Internal.SoundEvent_): Internal.InteractionResult;
        abstract interact(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.ItemStack_): Internal.InteractionResult;
        (arg0: Internal.BlockState, arg1: Internal.Level, arg2: BlockPos, arg3: Internal.Player, arg4: Internal.InteractionHand, arg5: Internal.ItemStack): Internal.InteractionResult_;
        readonly FILL_LAVA: Internal.CauldronInteraction;
        readonly BANNER: Internal.CauldronInteraction;
        readonly EMPTY: {[key: Internal.LingeringPotionItem]: any, [key: Internal.SolidBucketItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BucketItem]: any, [key: Internal.SplashPotionItem]: any, [key: Internal.PotionItem]: any};
        readonly SHULKER_BOX: Internal.CauldronInteraction;
        readonly LAVA: {[key: Internal.BucketItem]: any, [key: Internal.SolidBucketItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BucketItem]: any};
        readonly FILL_WATER: Internal.CauldronInteraction;
        readonly POWDER_SNOW: {[key: Internal.BucketItem]: any, [key: Internal.SolidBucketItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BucketItem]: any};
        readonly FILL_POWDER_SNOW: Internal.CauldronInteraction;
        readonly DYED_ITEM: Internal.CauldronInteraction;
        readonly WATER: {[key: Internal.PortableCellItem]: any, [key: Internal.DyeableArmorItem]: any, [key: Internal.BannerItem]: any, [key: Internal.PortableCellItem]: any, [key: Internal.DyeableArmorItem]: any, [key: Internal.MemoryCardItem]: any, [key: Internal.BlockItem]: any, [key: Internal.CustomDyeableArmorItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.BottleItem]: any, [key: Internal.DyeableHorseArmorItem]: any, [key: Internal.PortableCellItem]: any, [key: Internal.BlockItem]: any, [key: slimeknights.tconstruct.fluids.item.BottleItem]: any, [key: Internal.PortableCellItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BannerItem]: any, [key: Internal.PortableCellItem]: any, [key: Internal.SpaceSuitItem]: any, [key: slimeknights.tconstruct.fluids.item.BottleItem]: any, [key: Internal.PortableCellItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.BannerItem]: any, [key: Internal.PortableCellItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BucketItem]: any, [key: Internal.SolidBucketItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.BannerItem]: any, [key: Internal.PortableCellItem]: any, [key: Internal.CustomDyeableArmorItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BannerItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BlockItem]: any, [key: Internal.DyeableArmorItem]: any, [key: Internal.BannerItem]: any, [key: Internal.LingeringPotionItem]: any, [key: Internal.PortableCellItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BannerItem]: any, [key: Internal.DuckItem]: any, [key: Internal.CustomDyeableArmorItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.BucketItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.BlockItem]: any, [key: Internal.BlockItem]: any, [key: Internal.SplashPotionItem]: any, [key: Internal.PortableCellItem]: any, [key: Internal.PotionItem]: any, [key: Internal.TurtleItem]: any, [key: Internal.BlockItem]: any, [key: Internal.DyeableArmorItem]: any, [key: Internal.BackpackItem]: any, [key: Internal.TurtleItem]: any};
    }
    type CauldronInteraction_ = CauldronInteraction;
    interface ICustomBlockHitEffect {
        abstract addHitEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: Internal.HitResult_, arg3: Internal.ParticleEngine_): boolean;
        (arg0: Internal.BlockState, arg1: Internal.Level, arg2: Internal.HitResult, arg3: Internal.ParticleEngine): boolean;
    }
    type ICustomBlockHitEffect_ = ICustomBlockHitEffect;
    class BrassDiodeBlock extends Internal.AbstractDiodeBlock implements Internal.ConnectableRedstoneBlock, Internal.IBE<Internal.BrassDiodeBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityType(): Internal.BlockEntityType<Internal.BrassDiodeBlockEntity>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.BrassDiodeBlockEntity>): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        canConnectRedstone(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.BrassDiodeBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityClass(): typeof Internal.BrassDiodeBlockEntity;
        emi(amount: number): Internal.EmiStack;
        toggle(pLevel: Internal.Level_, pPos: BlockPos_, pState: Internal.BlockState_, player: Internal.Player_, pHand: Internal.InteractionHand_): Internal.InteractionResult;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.BrassDiodeBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.BrassDiodeBlockEntity>;
        get blockEntityType(): Internal.BlockEntityType<Internal.BrassDiodeBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.BrassDiodeBlockEntity
        static readonly POWERING: Internal.BooleanProperty;
        static readonly INVERTED: Internal.BooleanProperty;
    }
    type BrassDiodeBlock_ = BrassDiodeBlock;
    class FenceBlockBuilder extends Internal.MultipartShapedBlockBuilder {
        constructor(i: ResourceLocation_)
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): any;
    }
    type FenceBlockBuilder_ = FenceBlockBuilder;
    interface AccessorSmithingTransformRecipe {
        abstract getTemplate(): Internal.Ingredient;
        abstract getBase(): Internal.Ingredient;
        abstract getAddition(): Internal.Ingredient;
        get template(): Internal.Ingredient
        get base(): Internal.Ingredient
        get addition(): Internal.Ingredient
    }
    type AccessorSmithingTransformRecipe_ = AccessorSmithingTransformRecipe;
    interface RemovableIdList <T> {
        abstract fabric_remove(arg0: T): void;
        abstract fabric_remapId(arg0: number, arg1: number): void;
        abstract fabric_remapIds(arg0: Internal.Int2IntMap_): void;
        abstract fabric_removeId(arg0: number): void;
        abstract fabric_clear(): void;
    }
    type RemovableIdList_<T> = RemovableIdList<T>;
    class RegistrateDataProvider$DataInfo extends Internal.Record {
        constructor(output: Internal.FabricDataOutput_, helper: Internal.ExistingFileHelper_, registriesLookup: Internal.CompletableFuture_<Internal.HolderLookup$Provider>)
        registriesLookup(): Internal.CompletableFuture<Internal.HolderLookup$Provider>;
        output(): Internal.FabricDataOutput;
        helper(): Internal.ExistingFileHelper;
    }
    type RegistrateDataProvider$DataInfo_ = RegistrateDataProvider$DataInfo;
    class FastMap <Value> {
        constructor(properties: Internal.Collection_<Internal.Property<any>>, valuesMap: Internal.Map_<Internal.Map<Internal.Property<any>, Internal.Comparable<any>>, Value>, compact: boolean)
        getValue<T extends Internal.Comparable<T>>(stateIndex: number, property: Internal.Property_<T>): T;
        getPropertySet(): Internal.ImmutableSet<Internal.Property<any>>;
        getEntry(propertyIndex: number, stateIndex: number): Internal.Map$Entry<Internal.Property<any>, Internal.Comparable<any>>;
        getIndexOf(state: Internal.Map_<Internal.Property<any>, Internal.Comparable<any>>): number;
        withUnsafe<T extends Internal.Comparable<T>>(globalTableIndex: number, property: Internal.Property_<T>, newValue: any): Value;
        getValue(stateIndex: number, key: any): Internal.Comparable<any>;
        getKey(keyIndex: number): Internal.FastMapKey<any>;
        isSingleState(): boolean;
        "with"<T extends Internal.Comparable<T>>(oldIndex: number, prop: Internal.Property_<T>, value: T): Value;
        numProperties(): number;
        get propertySet(): Internal.ImmutableSet<Internal.Property<any>>
        get singleState(): boolean
    }
    type FastMap_<Value> = FastMap<Value>;
    abstract class TrackSwitchBlock extends Internal.HorizontalDirectionalBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.TrackSwitchBlockEntity> {
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.TrackSwitchBlockEntity>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.TrackSwitchBlockEntity;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.TrackSwitchBlockEntity>;
        setRequiresTool(v: boolean): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.TrackSwitchBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static automatic(properties: Internal.BlockBehaviour$Properties_): Internal.TrackSwitchBlock;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        static manual(properties: Internal.BlockBehaviour$Properties_): Internal.TrackSwitchBlock;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityClass(): typeof Internal.TrackSwitchBlockEntity;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.TrackSwitchBlockEntity>): void;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.TrackSwitchBlockEntity>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.TrackSwitchBlockEntity
        static readonly LOCKED: Internal.BooleanProperty;
    }
    type TrackSwitchBlock_ = TrackSwitchBlock;
    class ChunkTracker implements Internal.ClientChunkEventListener {
        constructor()
        updateLoadDistance(loadDistance: number): void;
        static forEachChunk(queue: Internal.LongCollection_, handler: Internal.ChunkTracker$ChunkEventHandler_): void;
        forEachEvent(loadEventHandler: Internal.ChunkTracker$ChunkEventHandler_, unloadEventHandler: Internal.ChunkTracker$ChunkEventHandler_): void;
        onChunkStatusRemoved(x: number, z: number, flags: number): void;
        getReadyChunks(): Internal.LongCollection;
        onChunkStatusAdded(x: number, z: number, flags: number): void;
        updateMapCenter(chunkX: number, chunkZ: number): void;
        get readyChunks(): Internal.LongCollection
    }
    type ChunkTracker_ = ChunkTracker;
    interface InternalInventory extends Internal.ItemTransfer, Internal.Iterable<Internal.ItemStack> {
        simulateRemove(amount: number, filter: Internal.ItemStack_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        addItems(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        toContainer(): net.minecraft.world.Container;
        getSubInventory(fromSlotInclusive: number, toSlotExclusive: number): this;
        isEmpty(): boolean;
        removeItems(amount: number, filter: Internal.ItemStack_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        sendChangeNotification(slot: number): void;
        toStorage(): Internal.Storage<Internal.ItemVariant>;
        abstract getStackInSlot(arg0: number): Internal.ItemStack;
        removeSimilarItems(amount: number, filter: Internal.ItemStack_, fuzzyMode: Internal.FuzzyMode_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        wrapExternal(be: Internal.BlockEntity_, side: Internal.Direction_): Internal.ItemTransfer;
        empty(): this;
        getSlotInv(slotIndex: number): this;
        mayAllowInsertion(): boolean;
        addItems(stack: Internal.ItemStack_): Internal.ItemStack;
        getSlotLimit(slot: number): number;
        iterator(): Internal.Iterator<Internal.ItemStack>;
        simulateSimilarRemove(amount: number, filter: Internal.ItemStack_, fuzzyMode: Internal.FuzzyMode_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        spliterator(): Internal.Spliterator<Internal.ItemStack>;
        simulateAdd(stack: Internal.ItemStack_): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract size(): number;
        forEach(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        abstract setItemDirect(arg0: number, arg1: Internal.ItemStack_): void;
        clear(): void;
        getRedstoneSignal(): number;
        wrapExternal(level: Internal.Level_, pos: BlockPos_, side: Internal.Direction_): Internal.ItemTransfer;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        get empty(): boolean
        get redstoneSignal(): number
    }
    type InternalInventory_ = InternalInventory;
    class StringComponent$1 implements Internal.RecipeComponent<string> {
        checkEmpty(key: Internal.RecipeKey_<string>, value: string): string;
        write(arg0: Internal.RecipeJS_, arg1: any): Internal.JsonElement;
        and<O>(other: Internal.RecipeComponent_<O>): Internal.AndRecipeComponent<string, O>;
        orSelf(): Internal.RecipeComponent<string>;
        isOutput(recipe: Internal.RecipeJS_, value: string, match: Internal.ReplacementMatch_): boolean;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read
        */
        mapIn(mappingTo: Internal.UnaryOperator_<any>): Internal.MappingRecipeComponent<string>;
        readFromJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<string>, json: Internal.JsonObject_): void;
        role(): Internal.ComponentRole;
        componentClass(): typeof any;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read, and the mappingFrom function after the component writes to json, before that json is saved
        */
        map(mappingTo: Internal.UnaryOperator_<any>, mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<string>;
        asMap<K>(key: Internal.RecipeComponent_<K>): Internal.RecipeComponent<Internal.TinyMap<K, string>>;
        readFromMap(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<string>, map: Internal.Map_<any, any>): void;
        replaceOutput(recipe: Internal.RecipeJS_, original: string, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): string;
        writeToJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<string>, json: Internal.JsonObject_): void;
        constructorDescription(ctx: Internal.DescriptionContext_): Internal.TypeDescJS;
        componentType(): string;
        checkValueHasChanged(oldValue: string, newValue: string): boolean;
        write(recipe: Internal.RecipeJS_, value: string): Internal.JsonElement;
        static builder(): Internal.RecipeComponentBuilder;
        /**
         * Returns a new RecipeComponent that applies the mappingFrom function after the component writes to json, before that json is saved
        */
        mapOut(mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<string>;
        hasPriority(recipe: Internal.RecipeJS_, from: any): boolean;
        replaceInput(recipe: Internal.RecipeJS_, original: string, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): string;
        static builder(...key: Internal.RecipeKey_<any>[]): Internal.RecipeComponentBuilder;
        read(arg0: Internal.RecipeJS_, arg1: any): any;
        isInput(recipe: Internal.RecipeJS_, value: string, match: Internal.ReplacementMatch_): boolean;
        or<O>(other: Internal.RecipeComponent_<O>): Internal.OrRecipeComponent<string, O>;
        asArray(): Internal.ArrayRecipeComponent<string>;
        asArrayOrSelf(): Internal.ArrayRecipeComponent<string>;
        asPatternKey(): Internal.RecipeComponent<Internal.TinyMap<string, string>>;
        key(name: string): Internal.RecipeKey<string>;
        /**
         * Returns a new RecipeComponent that maps the keys in a JsonObject according to the provided map, both before the json gets passed to the component and after the component returns a written json object.
         * The mappings should be provided in the format `{recipe: "component"}` where recipe is the key as in the recipe, and component is the key as how the RecipeComponent expects it.
         * Any keys not included in the provided map will be ignored, and any keys in the provided map that are not in either the input object or output object will be ignored.
         * Note that if the input or output is not a JsonObject (ie its an ItemStack, or it is a JsonPrimitive) then that will pass through this without being modified.
         * If you wish to handle those situations use the actual map function
        */
        simpleMap(mappings: any): Internal.SimpleMappingRecipeComponent<string>;
    }
    type StringComponent$1_ = StringComponent$1;
    interface BrainAccessor <E extends Internal.LivingEntity> {
        abstract getSensors(): Internal.Map<Internal.SensorType<Internal.Sensor<E>>, Internal.Sensor<E>>;
        get sensors(): Internal.Map<Internal.SensorType<Internal.Sensor<E>>, Internal.Sensor<E>>
        (): Internal.Map_<Internal.SensorType<Internal.Sensor<E>>, Internal.Sensor<E>>;
    }
    type BrainAccessor_<E extends Internal.LivingEntity> = BrainAccessor<E>;
    class ClientboundLightUpdatePacketData {
        constructor($$0: Internal.ChunkPos_, $$1: Internal.LevelLightEngine_, $$2: Internal.BitSet_, $$3: Internal.BitSet_)
        constructor($$0: Internal.FriendlyByteBuf_, $$1: number, $$2: number)
        getEmptyBlockYMask(): Internal.BitSet;
        getEmptySkyYMask(): Internal.BitSet;
        write($$0: Internal.FriendlyByteBuf_): void;
        getBlockUpdates(): Internal.List<number[]>;
        getBlockYMask(): Internal.BitSet;
        getSkyUpdates(): Internal.List<number[]>;
        getSkyYMask(): Internal.BitSet;
        get emptyBlockYMask(): Internal.BitSet
        get emptySkyYMask(): Internal.BitSet
        get blockUpdates(): Internal.List<number[]>
        get blockYMask(): Internal.BitSet
        get skyUpdates(): Internal.List<number[]>
        get skyYMask(): Internal.BitSet
    }
    type ClientboundLightUpdatePacketData_ = ClientboundLightUpdatePacketData;
    interface Iterator <E> {
        remove(): void;
        forEachRemaining(arg0: Internal.Consumer_<E>): void;
        abstract next(): E;
        abstract hasNext(): boolean;
    }
    type Iterator_<E> = Iterator<E>;
    /**
     * Invoked when a player right clicks with an item **without targeting anything**.
     * 
     * Not to be confused with `BlockEvents.rightClick` or `ItemEvents.entityInteracted`.
    */
    class ItemClickedEventJS extends Internal.PlayerEventJS {
        constructor(player: Internal.Player_, hand: Internal.InteractionHand_, item: Internal.ItemStack_)
        /**
         * The player that clicked with the item.
        */
        getEntity(): Internal.LivingEntity;
        /**
         * The ray trace result of the click.
        */
        getTarget(): Internal.RayTraceResultJS;
        /**
         * The item that was clicked with.
        */
        getItem(): Internal.ItemStack;
        /**
         * The hand that the item was clicked with.
        */
        getHand(): Internal.InteractionHand;
        /**
         * The player that clicked with the item.
        */
        get entity(): Internal.LivingEntity
        /**
         * The ray trace result of the click.
        */
        get target(): Internal.RayTraceResultJS
        /**
         * The item that was clicked with.
        */
        get item(): Internal.ItemStack
        /**
         * The hand that the item was clicked with.
        */
        get hand(): Internal.InteractionHand
    }
    type ItemClickedEventJS_ = ItemClickedEventJS;
    class CellWorkbenchBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CellWorkbenchBlock_ = CellWorkbenchBlock;
    class LoggedChatEvent$Type extends Internal.Enum<Internal.LoggedChatEvent$Type> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.LoggedChatEvent$Type[];
        static valueOf($$0: string): Internal.LoggedChatEvent$Type;
        get serializedName(): string
        static readonly SYSTEM: Internal.LoggedChatEvent$Type;
        static readonly PLAYER: Internal.LoggedChatEvent$Type;
    }
    type LoggedChatEvent$Type_ = LoggedChatEvent$Type | "player" | "system";
    class ClientboundSetObjectivePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.Objective_, $$1: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        getDisplayName(): net.minecraft.network.chat.Component;
        handle(arg0: Internal.PacketListener_): void;
        getMethod(): number;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getRenderType(): Internal.ObjectiveCriteria$RenderType;
        isSkippable(): boolean;
        getObjectiveName(): string;
        get displayName(): net.minecraft.network.chat.Component
        get method(): number
        get renderType(): Internal.ObjectiveCriteria$RenderType
        get skippable(): boolean
        get objectiveName(): string
        static readonly METHOD_ADD: 0;
        static readonly METHOD_CHANGE: 2;
        static readonly METHOD_REMOVE: 1;
    }
    type ClientboundSetObjectivePacket_ = ClientboundSetObjectivePacket;
    abstract class AbstractArrow extends Internal.Projectile implements Internal.AccessorAbstractArrow {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        setEnchantmentEffectsFromEntity($$0: Internal.LivingEntity_, $$1: number): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        method_5652($$0: Internal.CompoundTag_): void;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        setNoPhysics($$0: boolean): void;
        alwaysAccepts(): boolean;
        getDisplayName(): net.minecraft.network.chat.Component;
        isCritArrow(): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        setCritArrow($$0: boolean): void;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getPierceLevel(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        setBaseDamage($$0: number): void;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        playSound(id: Internal.SoundEvent_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        handler$zil002$ad_astra$adastra$tick(ci: Internal.CallbackInfo_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setRotation(yaw: number, pitch: number): void;
        hex$isInGround(): boolean;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        setShotFromCrossbow($$0: boolean): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getBaseDamage(): number;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        doPostHurtEffects($$0: Internal.LivingEntity_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        sophisticatedInvalidateCaps(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setSoundEvent($$0: Internal.SoundEvent_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        shotFromCrossbow(): boolean;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isNoPhysics(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getKnockback(): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        lithiumOnBlockCacheDeleted(): void;
        setKnockback($$0: number): void;
        runCommand(command: string): number;
        abstract getPickupItem(): Internal.ItemStack;
        setPierceLevel($$0: number): void;
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        set noPhysics($$0: boolean)
        get displayName(): net.minecraft.network.chat.Component
        get critArrow(): boolean
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        set critArrow($$0: boolean)
        get teamId(): string
        get facing(): Internal.Direction
        get pierceLevel(): number
        get motionX(): number
        get waterCreature(): boolean
        set baseDamage($$0: number)
        get item(): Internal.ItemStack
        set x(x: number)
        get frame(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set shotFromCrossbow($$0: boolean)
        get block(): Internal.BlockContainerJS
        get baseDamage(): number
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set soundEvent($$0: Internal.SoundEvent_)
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        get noPhysics(): boolean
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set dynamicLightEnabled(enabled: boolean)
        get motionZ(): number
        get knockback(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set knockback($$0: number)
        get pickupItem(): Internal.ItemStack
        set pierceLevel($$0: number)
        pickup: Internal.AbstractArrow$Pickup;
        piercedAndKilledEntities: Internal.List<Internal.Entity>;
        soundEvent: Internal.SoundEvent;
        piercingIgnoreEntityIds: Internal.IntOpenHashSet;
        shakeTime: number;
    }
    type AbstractArrow_ = AbstractArrow;
    class SmokerMenu extends Internal.AbstractFurnaceMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: net.minecraft.world.Container_, $$3: Internal.ContainerData_)
        constructor($$0: number, $$1: Internal.Inventory_)
    }
    type SmokerMenu_ = SmokerMenu;
    interface PoolChunkListMetric extends Internal.Iterable<Internal.PoolChunkMetric> {
        abstract maxUsage(): number;
        forEach(arg0: Internal.Consumer_<Internal.PoolChunkMetric>): void;
        abstract minUsage(): number;
        abstract iterator(): Internal.Iterator<Internal.PoolChunkMetric>;
        spliterator(): Internal.Spliterator<Internal.PoolChunkMetric>;
    }
    type PoolChunkListMetric_ = PoolChunkListMetric;
    class HoglinSpecificSensor extends Internal.Sensor<Internal.Hoglin> {
        constructor()
    }
    type HoglinSpecificSensor_ = HoglinSpecificSensor;
    class PumpkinPatchFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type PumpkinPatchFeature_ = PumpkinPatchFeature;
    class TechnicalGravestoneBlock extends Internal.AbstractGravestoneBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(world: Internal.Level_, state: Internal.BlockState_, type: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static createSoulParticles(world: Internal.Level_, pos: BlockPos_): void;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly DAMAGE: Internal.IntegerProperty;
    }
    type TechnicalGravestoneBlock_ = TechnicalGravestoneBlock;
    interface AccessorAbstractArrow {
        abstract hex$isInGround(): boolean;
        (): boolean;
    }
    type AccessorAbstractArrow_ = AccessorAbstractArrow;
    interface IPartHost extends Internal.ICustomCableConnection {
        abstract notifyNeighbors(): void;
        abstract addPart<T extends Internal.IPart>(arg0: Internal.IPartItem_<T>, arg1: Internal.Direction_, arg2: Internal.Player_): T;
        abstract markForUpdate(): void;
        abstract selectPartLocal(arg0: Vec3d_): Internal.SelectedPart;
        abstract getColor(): Internal.AEColor;
        abstract isEmpty(): boolean;
        abstract notifyNeighborNow(arg0: Internal.Direction_): void;
        abstract removePartFromSide(arg0: Internal.Direction_): void;
        abstract getLocation(): Internal.DimensionalBlockPos;
        abstract replacePart<T extends Internal.IPart>(arg0: Internal.IPartItem_<T>, arg1: Internal.Direction_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): T;
        abstract clearContainer(): void;
        abstract partChanged(): void;
        abstract cleanup(): void;
        abstract getCollisionShape(arg0: Internal.CollisionContext_): Internal.VoxelShape;
        abstract markForSave(): void;
        abstract getFacadeContainer(): Internal.IFacadeContainer;
        abstract isInWorld(): boolean;
        abstract canAddPart(arg0: Internal.ItemStack_, arg1: Internal.Direction_): boolean;
        abstract removePart(arg0: Internal.IPart_): boolean;
        selectPartWorld(pos: Vec3d_): Internal.SelectedPart;
        abstract getPart(arg0: Internal.Direction_): Internal.IPart;
        abstract getCableConnectionLength(arg0: Internal.AECableType_): number;
        abstract getBlockEntity(): Internal.BlockEntity;
        abstract isBlocked(arg0: Internal.Direction_): boolean;
        abstract hasRedstone(): boolean;
        get color(): Internal.AEColor
        get empty(): boolean
        get location(): Internal.DimensionalBlockPos
        get facadeContainer(): Internal.IFacadeContainer
        get inWorld(): boolean
        get blockEntity(): Internal.BlockEntity
    }
    type IPartHost_ = IPartHost;
    interface RegistryIdRemapCallback <T> {
        abstract onRemap(arg0: Internal.RegistryIdRemapCallback$RemapState_<T>): void;
        event<T>(registry: Internal.Registry_<T>): net.fabricmc.fabric.api.event.Event<Internal.RegistryIdRemapCallback<T>>;
        (arg0: Internal.RegistryIdRemapCallback$RemapState<T>): void;
    }
    type RegistryIdRemapCallback_<T> = RegistryIdRemapCallback<T>;
    class NameMap$Builder <T> {
        id(p: Internal.Function_<T, string>): this;
        nameKey(p: Internal.Function_<T, string>): this;
        create(): Internal.NameMap<T>;
        icon(p: Internal.Function_<T, Internal.Icon>): this;
        baseNameKey(key: string): this;
        name(p: Internal.Function_<T, net.minecraft.network.chat.Component>): this;
        color(p: Internal.Function_<T, Internal.Color4I>): this;
    }
    type NameMap$Builder_<T> = NameMap$Builder<T>;
    interface DynamicLightBehavior {
        abstract getBoundingBox(): Internal.DynamicLightBehavior$BoundingBox;
        abstract lightAtPos(arg0: BlockPos_, arg1: number): number;
        isRemoved(): boolean;
        abstract hasChanged(): boolean;
        get boundingBox(): Internal.DynamicLightBehavior$BoundingBox
        get removed(): boolean
    }
    type DynamicLightBehavior_ = DynamicLightBehavior;
    class ChannelInboundHandlerAdapter extends Internal.ChannelHandlerAdapter implements Internal.ChannelInboundHandler {
        constructor()
        channelWritabilityChanged(arg0: Internal.ChannelHandlerContext_): void;
        channelInactive(arg0: Internal.ChannelHandlerContext_): void;
        channelActive(arg0: Internal.ChannelHandlerContext_): void;
        channelUnregistered(arg0: Internal.ChannelHandlerContext_): void;
        userEventTriggered(arg0: Internal.ChannelHandlerContext_, arg1: any): void;
        channelReadComplete(arg0: Internal.ChannelHandlerContext_): void;
        channelRegistered(arg0: Internal.ChannelHandlerContext_): void;
        channelRead(arg0: Internal.ChannelHandlerContext_, arg1: any): void;
    }
    type ChannelInboundHandlerAdapter_ = ChannelInboundHandlerAdapter;
    class JobAttributes$MultipleDocumentHandlingType extends Internal.AttributeValue {
        static readonly SEPARATE_DOCUMENTS_COLLATED_COPIES: Internal.JobAttributes$MultipleDocumentHandlingType;
        static readonly SEPARATE_DOCUMENTS_UNCOLLATED_COPIES: Internal.JobAttributes$MultipleDocumentHandlingType;
    }
    type JobAttributes$MultipleDocumentHandlingType_ = JobAttributes$MultipleDocumentHandlingType;
    class VertexBuffer implements Internal.VertexBufferHelper, Internal.AutoCloseable {
        constructor($$0: any_)
        static unbind(): void;
        bind(): void;
        draw(): void;
        getFormat(): Internal.VertexFormat;
        upload($$0: Internal.BufferBuilder$RenderedBuffer_): void;
        isInvalid(): boolean;
        close(): void;
        restoreBinding(): void;
        saveBinding(): void;
        drawWithShader($$0: Matrix4f_, $$1: Matrix4f_, $$2: Internal.ShaderInstance_): void;
        get format(): Internal.VertexFormat
        get invalid(): boolean
        vertexBufferId: number;
        indexType: Internal.VertexFormat$IndexType;
        indexCount: number;
        sequentialIndices: Internal.RenderSystem$AutoStorageIndexBuffer;
        format: Internal.VertexFormat;
        mode: Internal.VertexFormat$Mode;
    }
    type VertexBuffer_ = VertexBuffer;
    interface IngredientKJS extends Internal.IngredientSupplierKJS, Internal.JsonSerializable {
        getDisplayStacks(): Internal.ItemStackSet;
        self(): Internal.Ingredient;
        getItemIds(): Internal.Set<string>;
        asStack(): InputItem;
        withCount(count: number): InputItem;
        toJson(): Internal.JsonElement;
        or(ingredient: Internal.Ingredient_): Internal.Ingredient;
        getStacks(): Internal.ItemStackSet;
        isWildcard(): boolean;
        canBeUsedForMatching(): boolean;
        getItemTypes(): Internal.Set<Internal.Item>;
        and(ingredient: Internal.Ingredient_): Internal.Ingredient;
        getFirst(): Internal.ItemStack;
        subtract(subtracted: Internal.Ingredient_): Internal.Ingredient;
        testItem(item: Internal.Item_): boolean;
        asIngredient(): Internal.Ingredient;
        get displayStacks(): Internal.ItemStackSet
        get itemIds(): Internal.Set<string>
        get stacks(): Internal.ItemStackSet
        get wildcard(): boolean
        get itemTypes(): Internal.Set<Internal.Item>
        get first(): Internal.ItemStack
    }
    type IngredientKJS_ = IngredientKJS;
    class RealmsNewsManager {
        constructor($$0: any_)
        updateUnreadNews($$0: Internal.RealmsNews_): void;
        hasUnreadNews(): boolean;
        newsLink(): string;
    }
    type RealmsNewsManager_ = RealmsNewsManager;
    class Vector <E> extends Internal.AbstractList<E> implements Internal.RandomAccess, Internal.Cloneable, Internal.List<E>, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.Collection_<E>)
        constructor(arg0: number, arg1: number)
        constructor(arg0: number)
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        addLast(arg0: E): void;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        getLast(): E;
        insertElementAt(arg0: E, arg1: number): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeElementAt(arg0: number): void;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        removeElement(arg0: any): boolean;
        addElement(arg0: E): void;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        subList(arg0: number, arg1: number): Internal.List<E>;
        copyInto(arg0: any[]): void;
        trimToSize(): void;
        addFirst(arg0: E): void;
        toArray<T>(arg0: T[]): T[];
        elements(): Internal.Enumeration<E>;
        listIterator(arg0: number): Internal.ListIterator<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        stream(): Internal.Stream<E>;
        ensureCapacity(arg0: number): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        removeLast(): E;
        setElementAt(arg0: E, arg1: number): void;
        clone(): any;
        get(arg0: number): E;
        capacity(): number;
        listIterator(): Internal.ListIterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        removeFirst(): E;
        parallelStream(): Internal.Stream<E>;
        firstElement(): E;
        lastElement(): E;
        set(arg0: number, arg1: E): E;
        static of<E>(...arg0: E[]): Internal.List<E>;
        elementAt(arg0: number): E;
        remove(arg0: number): E;
        indexOf(arg0: any, arg1: number): number;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        lastIndexOf(arg0: any, arg1: number): number;
        getFirst(): E;
        removeAllElements(): void;
        spliterator(): Internal.Spliterator<E>;
        setSize(arg0: number): void;
        get last(): E
        get first(): E
        set size(arg0: number)
    }
    type Vector_<E> = Vector<E>;
    class WorldAttached <T> {
        constructor(factory: Internal.Function_<Internal.LevelAccessor, T>)
        empty(finalizer: Internal.BiConsumer_<Internal.LevelAccessor, T>): void;
        put(world: Internal.LevelAccessor_, entry: T): void;
        get(world: Internal.LevelAccessor_): T;
        replace(world: Internal.LevelAccessor_, finalizer: Internal.Consumer_<T>): T;
        replace(world: Internal.LevelAccessor_): T;
        empty(finalizer: Internal.Consumer_<T>): void;
        static invalidateWorld(world: Internal.LevelAccessor_): void;
    }
    type WorldAttached_<T> = WorldAttached<T>;
    class DaylightDetectorBlockEntity extends Internal.BlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
    }
    type DaylightDetectorBlockEntity_ = DaylightDetectorBlockEntity;
    abstract class SimpleFabricLootTableProvider implements Internal.FabricLootTableProvider {
        constructor(output: Internal.FabricDataOutput_, lootContextType: Internal.LootContextParamSet_)
        run(writer: Internal.CachedOutput_): Internal.CompletableFuture<any>;
        getName(): string;
        abstract generate(arg0: Internal.BiConsumer_<ResourceLocation, Internal.LootTable$Builder>): void;
        withConditions(exporter: Internal.BiConsumer_<ResourceLocation, Internal.LootTable$Builder>, ...conditions: any_[]): Internal.BiConsumer<ResourceLocation, Internal.LootTable$Builder>;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        get name(): string
    }
    type SimpleFabricLootTableProvider_ = SimpleFabricLootTableProvider;
    class QuartzHoeItem extends Internal.HoeItem {
        constructor(props: Internal.Item$Properties_, type: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        static getTillingActions(): Internal.Map<Internal.Block, com.mojang.datafixers.util.Pair<Internal.Predicate<Internal.UseOnContext>, Internal.Consumer<Internal.UseOnContext>>>;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get tillingActions(): Internal.Map<Internal.Block, com.mojang.datafixers.util.Pair<Internal.Predicate<Internal.UseOnContext>, Internal.Consumer<Internal.UseOnContext>>>
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type QuartzHoeItem_ = QuartzHoeItem;
    class TallSeagrassBlock extends Internal.DoublePlantBlock implements Internal.LiquidBlockContainer {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    }
    type TallSeagrassBlock_ = TallSeagrassBlock;
    class ConstantHeight extends Internal.HeightProvider {
        static of($$0: Internal.VerticalAnchor_): Internal.ConstantHeight;
        getValue(): Internal.VerticalAnchor;
        get value(): Internal.VerticalAnchor
        static readonly CODEC: Internal.Codec<Internal.ConstantHeight>;
        static readonly ZERO: Internal.ConstantHeight;
    }
    type ConstantHeight_ = ConstantHeight;
    interface AccessorScreen {
        abstract getNarratables(): Internal.List<Internal.NarratableEntry>;
        abstract getRenderables(): Internal.List<Internal.Renderable>;
        get narratables(): Internal.List<Internal.NarratableEntry>
        get renderables(): Internal.List<Internal.Renderable>
    }
    type AccessorScreen_ = AccessorScreen;
    class BlockColumnConfiguration$Layer extends Internal.Record {
        constructor($$0: Internal.IntProvider_, $$1: Internal.BlockStateProvider_)
        state(): Internal.BlockStateProvider;
        height(): Internal.IntProvider;
        static readonly CODEC: Internal.Codec<Internal.BlockColumnConfiguration$Layer>;
    }
    type BlockColumnConfiguration$Layer_ = BlockColumnConfiguration$Layer;
    class RegularImmutableMap <K, V> extends Internal.ImmutableMap<K, V> {
        entrySet(): Internal.Set<any>;
        get(arg0: any): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        values(): Internal.Collection<any>;
    }
    type RegularImmutableMap_<K, V> = RegularImmutableMap<K, V>;
    interface Char2ByteFunction extends it.unimi.dsi.fastutil.Function<string, number>, Internal.IntUnaryOperator {
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, string>): Internal.Function<T, number>;
        composeReference<T>(arg0: Internal.Reference2CharFunction_<T>): Internal.Reference2ByteFunction<T>;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Char2ReferenceFunction<T>;
        put(arg0: string, arg1: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Char2IntFunction;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        containsKey(arg0: string): boolean;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        defaultReturnValue(arg0: number): void;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Char2ObjectFunction<T>;
        composeShort(arg0: Internal.Short2CharFunction_): Internal.Short2ByteFunction;
        composeObject<T>(arg0: Internal.Object2CharFunction_<T>): Internal.Object2ByteFunction<T>;
        getOrDefault(arg0: string, arg1: number): number;
        composeLong(arg0: Internal.Long2CharFunction_): Internal.Long2ByteFunction;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        composeDouble(arg0: Internal.Double2CharFunction_): Internal.Double2ByteFunction;
        composeFloat(arg0: Internal.Float2CharFunction_): Internal.Float2ByteFunction;
        abstract get(arg0: string): number;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Char2ShortFunction;
        composeInt(arg0: Internal.Int2CharFunction_): Internal.Int2ByteFunction;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Char2CharFunction;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Char2LongFunction;
        composeByte(arg0: Internal.Byte2CharFunction_): Internal.Byte2ByteFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<string, T>;
        size(): number;
        composeChar(arg0: Internal.Char2CharFunction_): this;
        apply(arg0: string): number;
        remove(arg0: string): number;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Char2FloatFunction;
        clear(): void;
        /**
         * @deprecated
        */
        put(arg0: string, arg1: number): number;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Char2DoubleFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        (arg0: string): number;
    }
    type Char2ByteFunction_ = Char2ByteFunction;
    class AgriGenome {
        constructor(species: Internal.AgriGenePair_<string>, stats: Internal.List_<Internal.AgriGenePair<number>>)
        constructor(plant: Internal.AgriPlant_)
        getGrowth(): number;
        getGain(): number;
        getMutativity(): number;
        getStatGene(stat: Internal.AgriStat_): Internal.AgriGenePair<number>;
        getFertility(): number;
        writeToNBT(tag: Internal.CompoundTag_): void;
        getResistance(): number;
        getSpeciesGene(): Internal.AgriGenePair<string>;
        static removeFromNBT(tag: Internal.CompoundTag_): void;
        static fromNBT(tag: Internal.CompoundTag_): Internal.AgriGenome;
        getStrength(): number;
        appendHoverText(tooltipComponents: Internal.List_<net.minecraft.network.chat.Component>, isAdvanced: Internal.TooltipFlag_): void;
        getStatGenes(): Internal.Collection<Internal.AgriGenePair<number>>;
        get growth(): number
        get gain(): number
        get mutativity(): number
        get fertility(): number
        get resistance(): number
        get speciesGene(): Internal.AgriGenePair<string>
        get strength(): number
        get statGenes(): Internal.Collection<Internal.AgriGenePair<number>>
    }
    type AgriGenome_ = AgriGenome;
    interface ResourceManager extends Internal.ResourceProvider {
        open($$0: ResourceLocation_): Internal.InputStream;
        fromMap($$0: Internal.Map_<ResourceLocation, Internal.Resource>): Internal.ResourceProvider;
        abstract getResourceStack(arg0: ResourceLocation_): Internal.List<Internal.Resource>;
        openAsReader($$0: ResourceLocation_): Internal.BufferedReader;
        abstract getNamespaces(): Internal.Set<string>;
        abstract listResources(arg0: string, arg1: Internal.Predicate_<ResourceLocation>): Internal.Map<ResourceLocation, Internal.Resource>;
        abstract getResource(arg0: ResourceLocation_): Internal.Optional<Internal.Resource>;
        abstract listResourceStacks(arg0: string, arg1: Internal.Predicate_<ResourceLocation>): Internal.Map<ResourceLocation, Internal.List<Internal.Resource>>;
        abstract listPacks(): Internal.Stream<Internal.PackResources>;
        getResourceOrThrow($$0: ResourceLocation_): Internal.Resource;
        get namespaces(): Internal.Set<string>
    }
    type ResourceManager_ = ResourceManager;
    interface ChannelOutboundBuffer$MessageProcessor {
        abstract processMessage(arg0: any): boolean;
        (arg0: any): boolean;
    }
    type ChannelOutboundBuffer$MessageProcessor_ = ChannelOutboundBuffer$MessageProcessor;
    class PalettesSmokeboxBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type PalettesSmokeboxBlock_ = PalettesSmokeboxBlock;
    /**
     * Invoked when a player respawns.
     * 
     * The reason of respawn can be either death or returning from the end.
    */
    class PlayerRespawnedEventJS extends Internal.PlayerEventJS {
        constructor(player: Internal.ServerPlayer_, oldPlayer: Internal.ServerPlayer_, keepData: boolean)
        /**
         * Gets the player that respawned.
        */
        getEntity(): Internal.Entity;
        /**
         * Gets the player that was before respawn. Note that this entity is already removed from the world.
        */
        getOldPlayer(): Internal.ServerPlayer;
        /**
         * Gets whether the player's data was kept, e.g. when returning from the end.
        */
        getKeepData(): boolean;
        /**
         * Gets the player that respawned.
        */
        get entity(): Internal.Entity
        /**
         * Gets the player that was before respawn. Note that this entity is already removed from the world.
        */
        get oldPlayer(): Internal.ServerPlayer
        /**
         * Gets whether the player's data was kept, e.g. when returning from the end.
        */
        get keepData(): boolean
    }
    type PlayerRespawnedEventJS_ = PlayerRespawnedEventJS;
    class Piglin extends Internal.AbstractPiglin implements Internal.InventoryCarrier, Internal.CrossbowAttackMob {
        constructor($$0: Internal.EntityType_<Internal.AbstractPiglin>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        getInventory(): Internal.SimpleContainer;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        method_5992($$0: Internal.Player_, $$1: Internal.InteractionHand_): Internal.InteractionResult;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setChargingCrossbow($$0: boolean): void;
        setY(y: number): void;
        getBrain(): Internal.Brain<Internal.Piglin>;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getProjectileShotVector($$0: Internal.LivingEntity_, $$1: Vec3d_, $$2: number): Vec3f;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        static pickUpItem($$0: Internal.Mob_, $$1: Internal.InventoryCarrier_, $$2: Internal.ItemEntity_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        readInventoryFromTag($$0: Internal.CompoundTag_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        writeInventoryToTag($$0: Internal.CompoundTag_): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        shootCrossbowProjectile($$0: Internal.LivingEntity_, $$1: Internal.ItemStack_, $$2: Internal.Projectile_, $$3: number): void;
        isDancing(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        static checkPiglinSpawnRules($$0: Internal.EntityType_<Internal.Piglin>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        shootCrossbowProjectile($$0: Internal.LivingEntity_, $$1: Internal.LivingEntity_, $$2: Internal.Projectile_, $$3: number, $$4: number): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        performCrossbowAttack($$0: Internal.LivingEntity_, $$1: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        performRangedAttack($$0: Internal.LivingEntity_, $$1: number): void;
        onCrossbowAttackPerformed(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setDancing($$0: boolean): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        get inventory(): Internal.SimpleContainer
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set chargingCrossbow($$0: boolean)
        set y(y: number)
        get brain(): Internal.Brain<Internal.Piglin>
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get dancing(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set dancing($$0: boolean)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Piglin_ = Piglin;
    interface ArrayVoxelShapeAccessor {
        port_lib$init(discreteVoxelShape: Internal.DiscreteVoxelShape_, doubleList: Internal.DoubleList_, doubleList2: Internal.DoubleList_, doubleList3: Internal.DoubleList_): Internal.ArrayVoxelShape;
    }
    type ArrayVoxelShapeAccessor_ = ArrayVoxelShapeAccessor;
    class NoiseThresholdCountPlacement extends Internal.RepeatingPlacement {
        static of($$0: number, $$1: number, $$2: number): Internal.NoiseThresholdCountPlacement;
        static readonly CODEC: Internal.Codec<Internal.NoiseThresholdCountPlacement>;
    }
    type NoiseThresholdCountPlacement_ = NoiseThresholdCountPlacement;
    class ChestMenuData {
        constructor(player: Internal.ServerPlayer_, title: net.minecraft.network.chat.Component_, rows: number)
        handleClick(index: number, type: Internal.ClickType_, button: number): void;
        button(x: number, y: number, stack: Internal.ItemStack_, displayName: net.minecraft.network.chat.Component_, leftClicked: Internal.ChestMenuClickEvent$Callback_): void;
        getSlot(x: number, y: number): Internal.ChestMenuSlot;
        slot(x0: number, y0: number, x1: number, y1: number, slot: Internal.Consumer_<Internal.ChestMenuSlot>): void;
        slot(x: number, y: number, slot: Internal.Consumer_<Internal.ChestMenuSlot>): void;
        sync(): void;
        readonly slots: Internal.ChestMenuSlot[];
        playerSlots: boolean;
        inventoryClicked: Internal.ChestMenuInventoryClickEvent$Callback;
        closed: Internal.Runnable;
        capturedInventory: net.minecraft.world.Container;
        readonly rows: number;
        title: net.minecraft.network.chat.Component;
        anyClicked: Internal.ChestMenuClickEvent$Callback;
        readonly player: Internal.ServerPlayer;
        mouseItem: Internal.ItemStack;
    }
    type ChestMenuData_ = ChestMenuData;
    class Object2LongEntry implements Internal.Comparable<Internal.Object2LongEntry> {
        constructor(k: any, v: number)
        constructor(entry: Internal.Object2LongMap$Entry_<any>)
        compareTo(o: Internal.Object2LongEntry_): number;
        compareTo(arg0: any): number;
        readonly value: number;
        readonly key: any;
    }
    type Object2LongEntry_ = Object2LongEntry;
    class IOPortBlockEntity extends Internal.AENetworkInvBlockEntity implements Internal.IUpgradeableObject, Internal.IConfigurableObject, Internal.IGridTickable {
        constructor(blockEntityType: Internal.BlockEntityType_<any>, pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isActive(): boolean;
        getConfigManager(): Internal.IConfigManager;
        updateRedstoneState(): void;
        matchesFullnessMode(inv: Internal.StorageCell_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getTickingRequest(node: Internal.IGridNode_): Internal.TickingRequest;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isUpgradedWith(upgradeCard: Internal.ItemLike_): boolean;
        getInstalledUpgrades(upgradeCard: Internal.ItemLike_): number;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getGridConnectableSides(orientation: Internal.BlockOrientation_): Internal.Set<Internal.Direction>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getUpgrades(): Internal.IUpgradeInventory;
        tickingRequest(node: Internal.IGridNode_, ticksSinceLastCall: number): Internal.TickRateModulation;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        get active(): boolean
        get configManager(): Internal.IConfigManager
        get gridNode(): Internal.IGridNode
        get actionableNode(): Internal.IGridNode
        get upgrades(): Internal.IUpgradeInventory
        set owner(owner: Internal.Player_)
    }
    type IOPortBlockEntity_ = IOPortBlockEntity;
    class ConfigBase$ConfigInt extends Internal.ConfigBase$CValue<number, Internal.ForgeConfigSpec$IntValue> {
        constructor(this$0: Internal.ConfigBase_, name: string, current: number, min: number, max: number, ...comment: string[])
    }
    type ConfigBase$ConfigInt_ = ConfigBase$ConfigInt;
    class Panda$Gene extends Internal.Enum<Internal.Panda$Gene> implements Internal.StringRepresentable {
        static getRandom($$0: Internal.RandomSource_): Internal.Panda$Gene;
        static byId($$0: number): Internal.Panda$Gene;
        static byName($$0: string): Internal.Panda$Gene;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.Panda$Gene[];
        getSerializedName(): string;
        isRecessive(): boolean;
        static valueOf($$0: string): Internal.Panda$Gene;
        getId(): number;
        get serializedName(): string
        get recessive(): boolean
        get id(): number
        static readonly NORMAL: Internal.Panda$Gene;
        static readonly AGGRESSIVE: Internal.Panda$Gene;
        static readonly PLAYFUL: Internal.Panda$Gene;
        static readonly WORRIED: Internal.Panda$Gene;
        static readonly BROWN: Internal.Panda$Gene;
        static readonly WEAK: Internal.Panda$Gene;
        static readonly LAZY: Internal.Panda$Gene;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.Panda$Gene>;
    }
    type Panda$Gene_ = "normal" | "playful" | "worried" | "brown" | "lazy" | "weak" | Panda$Gene | "aggressive";
    class ItemPridePigment$Type extends Internal.Enum<Internal.ItemPridePigment$Type> {
        static valueOf(name: string): Internal.ItemPridePigment$Type;
        getName(): string;
        static values(): Internal.ItemPridePigment$Type[];
        get name(): string
        static readonly PANSEXUAL: Internal.ItemPridePigment$Type;
        static readonly AGENDER: Internal.ItemPridePigment$Type;
        static readonly DEMIBOY: Internal.ItemPridePigment$Type;
        static readonly AROACE: Internal.ItemPridePigment$Type;
        static readonly ASEXUAL: Internal.ItemPridePigment$Type;
        static readonly PLURAL: Internal.ItemPridePigment$Type;
        static readonly AROMANTIC: Internal.ItemPridePigment$Type;
        static readonly INTERSEX: Internal.ItemPridePigment$Type;
        static readonly GENDERFLUID: Internal.ItemPridePigment$Type;
        static readonly GENDERQUEER: Internal.ItemPridePigment$Type;
        static readonly LESBIAN: Internal.ItemPridePigment$Type;
        static readonly TRANSGENDER: Internal.ItemPridePigment$Type;
        static readonly BISEXUAL: Internal.ItemPridePigment$Type;
        static readonly DEMIGIRL: Internal.ItemPridePigment$Type;
        static readonly GAY: Internal.ItemPridePigment$Type;
        static readonly NONBINARY: Internal.ItemPridePigment$Type;
    }
    type ItemPridePigment$Type_ = "genderqueer" | "demiboy" | "agender" | "genderfluid" | "demigirl" | "transgender" | "pansexual" | ItemPridePigment$Type | "lesbian" | "asexual" | "intersex" | "gay" | "aroace" | "plural" | "nonbinary" | "aromantic" | "bisexual";
    class Team$Visibility extends Internal.Enum<Internal.Team$Visibility> {
        static byName($$0: string): Internal.Team$Visibility;
        getDisplayName(): net.minecraft.network.chat.Component;
        static values(): Internal.Team$Visibility[];
        static getAllNames(): string[];
        static valueOf($$0: string): Internal.Team$Visibility;
        get displayName(): net.minecraft.network.chat.Component
        get allNames(): string[]
        readonly name: string;
        readonly id: number;
        static readonly NEVER: Internal.Team$Visibility;
        static readonly HIDE_FOR_OTHER_TEAMS: Internal.Team$Visibility;
        static readonly HIDE_FOR_OWN_TEAM: Internal.Team$Visibility;
        static readonly ALWAYS: Internal.Team$Visibility;
    }
    type Team$Visibility_ = Team$Visibility | "never" | "hide_for_other_teams" | "hide_for_own_team" | "always";
    abstract class VoxelShape implements Internal.VoxelShapeAccess, Internal.OffsetVoxelShapeCache {
        constructor($$0: Internal.DiscreteVoxelShape_)
        max($$0: Internal.Direction$Axis_, $$1: number, $$2: number): number;
        findIndex(axis: Internal.Direction$Axis_, coord: number): number;
        getFaces(): Internal.VoxelShape[];
        max($$0: Internal.Direction$Axis_): number;
        closestPointTo($$0: Vec3d_): Internal.Optional<Vec3d>;
        isEmpty(): boolean;
        forAllEdges($$0: Internal.Shapes$DoubleLineConsumer_): void;
        abstract getCoords(arg0: Internal.Direction$Axis_): Internal.DoubleList;
        forAllBoxes($$0: Internal.Shapes$DoubleLineConsumer_): void;
        move($$0: number, $$1: number, $$2: number): this;
        setShape(arg0: Internal.DiscreteVoxelShape_): void;
        getFaceShape($$0: Internal.Direction_): this;
        setFaces(arg0: Internal.VoxelShape_[]): void;
        getOffsetSimplifiedShape(offset: number, direction: Internal.Direction_): this;
        min($$0: Internal.Direction$Axis_, $$1: number, $$2: number): number;
        getShape(): Internal.DiscreteVoxelShape;
        optimize(): this;
        collideX(cycleDirection: Internal.AxisCycle_, box: Internal.AABB_, maxDist: number): number;
        bounds(): Internal.AABB;
        toAabbs(): Internal.List<Internal.AABB>;
        min($$0: Internal.Direction$Axis_): number;
        clip($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_): Internal.BlockHitResult;
        setShape(offset: number, direction: Internal.Direction_, offsetShape: Internal.VoxelShape_): void;
        collide($$0: Internal.Direction$Axis_, $$1: Internal.AABB_, $$2: number): number;
        get faces(): Internal.VoxelShape[]
        get empty(): boolean
        set shape(arg0: Internal.DiscreteVoxelShape_)
        set faces(arg0: Internal.VoxelShape_[])
        get shape(): Internal.DiscreteVoxelShape
        shape: Internal.DiscreteVoxelShape;
    }
    type VoxelShape_ = VoxelShape;
    interface EntityEvents$NewLightingStrike {
        abstract onEntityStruckByLightning(arg0: Internal.EntityStruckByLightningEvent_): void;
        (arg0: Internal.EntityStruckByLightningEvent): void;
    }
    type EntityEvents$NewLightingStrike_ = EntityEvents$NewLightingStrike;
    class ToolboxMountedStorageType extends Internal.MountedItemStorageType<Internal.ToolboxMountedStorage> {
        constructor()
        mount(level: Internal.Level_, state: Internal.BlockState_, pos: BlockPos_, be: Internal.BlockEntity_): Internal.ToolboxMountedStorage;
    }
    type ToolboxMountedStorageType_ = ToolboxMountedStorageType;
    class GlowBallItem extends Internal.SnowballItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type GlowBallItem_ = GlowBallItem;
    class LootItemFunctionType extends Internal.SerializerType<Internal.LootItemFunction> {
        constructor($$0: Internal.Serializer_<Internal.LootItemFunction>)
    }
    type LootItemFunctionType_ = Special.LootFunctionType | LootItemFunctionType;
    class ServerLinkableHolder$Companion {
        constructor($constructor_marker: any_)
    }
    type ServerLinkableHolder$Companion_ = ServerLinkableHolder$Companion;
    class MapCloningRecipe extends Internal.CustomRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.CraftingBookCategory_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        assemble($$0: Internal.CraftingContainer_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type MapCloningRecipe_ = MapCloningRecipe;
    interface ISingleStackContainer extends Internal.IRecipeContainer {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem(itemIn: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf(set: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        abstract getStack(): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        /**
         * @deprecated
        */
        getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        /**
         * @deprecated
        */
        getItem(index: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get stack(): Internal.ItemStack
        get slots(): number
        /**
         * @deprecated
        */
        get containerSize(): number
        get height(): number
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        (): Internal.ItemStack_;
    }
    type ISingleStackContainer_ = ISingleStackContainer;
    class LiquidBlock extends Internal.Block implements Internal.FluidBlockAccessor, Internal.BucketPickup, Internal.InjectedLiquidBlockExtension, io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.LiquidBlockAccessor, Internal.LiquidBlockAccessor {
        constructor($$0: Internal.FlowingFluid_, $$1: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        arch$getFluid(): Internal.FlowingFluid;
        getFluid(): Internal.FlowingFluid;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        port_lib$getFluid(): Internal.FlowingFluid;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        static callInit(fluid: Internal.FlowingFluid_, settings: Internal.BlockBehaviour$Properties_): Internal.LiquidBlock;
        emi(amount: number): Internal.EmiStack;
        static "callInit$registrate-fabric_$md$fca01f$0"(arg0: Internal.FlowingFluid_, arg1: Internal.BlockBehaviour$Properties_): Internal.LiquidBlock;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get fluid(): Internal.FlowingFluid
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly POSSIBLE_FLOW_DIRECTIONS: [Internal.Direction, Internal.Direction, Internal.Direction, Internal.Direction, Internal.Direction];
        static readonly STABLE_SHAPE: Internal.VoxelShapeAlignedCuboid;
        static readonly LEVEL: Internal.IntegerProperty;
    }
    type LiquidBlock_ = LiquidBlock;
    interface FluidContainer extends earth.terrarium.botarium.util.Serializable, Internal.Clearable {
        holdsFluid(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, entity: Internal.BlockEntity_, direction: Internal.Direction_): boolean;
        tryClear($$0: any): void;
        of(block: Internal.BlockEntity_, direction: Internal.Direction_): this;
        holdsFluid(level: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        abstract setFluid(arg0: number, arg1: Internal.FluidHolder_): void;
        abstract getTankCapacity(arg0: number): number;
        abstract isEmpty(): boolean;
        abstract allowsInsertion(): boolean;
        getFirstFluid(): Internal.FluidHolder;
        abstract getSize(): number;
        holdsFluid(stack: Internal.ItemStack_): boolean;
        isFluidValid(slot: number, fluid: Internal.FluidHolder_): boolean;
        abstract allowsExtraction(): boolean;
        abstract serialize(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        readSnapshot(snapshot: Internal.FluidSnapshot_): void;
        of(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, entity: Internal.BlockEntity_, direction: Internal.Direction_): this;
        extractFromSlot(slot: number, toExtract: Internal.FluidHolder_, simulate: boolean): number;
        of(level: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_): this;
        abstract copy(): this;
        holdsFluid(block: Internal.BlockEntity_, direction: Internal.Direction_): boolean;
        abstract extractFromSlot(arg0: Internal.FluidHolder_, arg1: Internal.FluidHolder_, arg2: Internal.Runnable_): number;
        internalInsert(fluids: Internal.FluidHolder_, simulate: boolean): number;
        abstract fromContainer(arg0: Internal.FluidContainer_): void;
        abstract createSnapshot(): Internal.FluidSnapshot;
        abstract getFluids(): Internal.List<Internal.FluidHolder>;
        abstract insertFluid(arg0: Internal.FluidHolder_, arg1: boolean): number;
        getContainer(direction: Internal.Direction_): this;
        internalExtract(fluid: Internal.FluidHolder_, simulate: boolean): Internal.FluidHolder;
        abstract extractFluid(arg0: Internal.FluidHolder_, arg1: boolean): Internal.FluidHolder;
        of(holder: Internal.ItemStackHolder_): Internal.ItemFluidContainer;
        abstract deserialize(arg0: Internal.CompoundTag_): void;
        abstract clearContent(): void;
        get empty(): boolean
        get firstFluid(): Internal.FluidHolder
        get size(): number
        get fluids(): Internal.List<Internal.FluidHolder>
    }
    type FluidContainer_ = FluidContainer;
    class FoliageBlockBOP extends Internal.BushBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type FoliageBlockBOP_ = FoliageBlockBOP;
    interface ChunkHolder$PlayerProvider {
        abstract getPlayers(arg0: Internal.ChunkPos_, arg1: boolean): Internal.List<Internal.ServerPlayer>;
        (arg0: Internal.ChunkPos, arg1: boolean): Internal.List_<Internal.ServerPlayer>;
    }
    type ChunkHolder$PlayerProvider_ = ChunkHolder$PlayerProvider;
    class FogRenderer$FogMode extends Internal.Enum<Internal.FogRenderer$FogMode> {
        static valueOf($$0: string): Internal.FogRenderer$FogMode;
        static values(): Internal.FogRenderer$FogMode[];
        static readonly FOG_TERRAIN: Internal.FogRenderer$FogMode;
        static readonly FOG_SKY: Internal.FogRenderer$FogMode;
    }
    type FogRenderer$FogMode_ = FogRenderer$FogMode | "fog_sky" | "fog_terrain";
    interface DoubleIterable extends Internal.Iterable<number> {
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        forEach(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        iterator(): Internal.Iterator<any>;
        spliterator(): Internal.Spliterator<any>;
        doubleSpliterator(): Internal.DoubleSpliterator;
        forEach(arg0: Internal.DoubleConsumer_): void;
        doubleIterator(): Internal.DoubleIterator;
    }
    type DoubleIterable_ = DoubleIterable;
    class StringBuffer extends Internal.AbstractStringBuilder implements Internal.CharSequence, Internal.Comparable<Internal.StringBuffer>, Internal.Appendable, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.CharSequence_)
        constructor(arg0: number)
        constructor(arg0: string)
        appendCodePoint(arg0: number): this;
        append(arg0: number): this;
        append(arg0: number): this;
        deleteCharAt(arg0: number): this;
        compareTo(arg0: Internal.StringBuffer_): number;
        append(arg0: boolean): this;
        isEmpty(): boolean;
        append(arg0: Internal.CharSequence_, arg1: number, arg2: number): Internal.Appendable;
        compareTo(arg0: any): number;
        append(arg0: string): this;
        static compare(arg0: Internal.CharSequence_, arg1: Internal.CharSequence_): number;
        append(arg0: number): this;
        insert(arg0: number, arg1: any): this;
        append(arg0: string[], arg1: number, arg2: number): this;
        replace(arg0: number, arg1: number, arg2: string): this;
        reverse(): this;
        get empty(): boolean
    }
    type StringBuffer_ = StringBuffer;
    class AstralSorceryAmuletAttribute$Type implements Internal.ItemAttributeType {
        constructor()
        getAllAttributes(itemStack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type AstralSorceryAmuletAttribute$Type_ = AstralSorceryAmuletAttribute$Type;
    class ClientboundSetSimulationDistancePacket extends Internal.Record implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        simulationDistance(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundSetSimulationDistancePacket_ = ClientboundSetSimulationDistancePacket;
    interface ItemStackExtensions {
        onBlockStartBreak(pos: BlockPos_, player: Internal.Player_): boolean;
    }
    type ItemStackExtensions_ = ItemStackExtensions;
    interface Int2FloatFunction extends Internal.IntToDoubleFunction, it.unimi.dsi.fastutil.Function<number, number> {
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2FloatFunction;
        applyAsDouble(arg0: number): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        andThenShort(arg0: Internal.Float2ShortFunction_): Internal.Int2ShortFunction;
        apply(arg0: number): number;
        andThenByte(arg0: Internal.Float2ByteFunction_): Internal.Int2ByteFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        containsKey(arg0: number): boolean;
        defaultReturnValue(arg0: number): void;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2FloatFunction;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2FloatFunction<T>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2FloatFunction;
        andThenFloat(arg0: Internal.Float2FloatFunction_): this;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        andThenInt(arg0: Internal.Float2IntFunction_): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenLong(arg0: Internal.Float2LongFunction_): Internal.Int2LongFunction;
        remove(arg0: number): number;
        defaultReturnValue(): number;
        andThenDouble(arg0: Internal.Float2DoubleFunction_): Internal.Int2DoubleFunction;
        getOrDefault(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThenObject<T>(arg0: Internal.Float2ObjectFunction_<T>): Internal.Int2ObjectFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2FloatFunction<T>;
        size(): number;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2FloatFunction;
        andThenReference<T>(arg0: Internal.Float2ReferenceFunction_<T>): Internal.Int2ReferenceFunction<T>;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2FloatFunction;
        clear(): void;
        abstract get(arg0: number): number;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2FloatFunction;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        andThenChar(arg0: Internal.Float2CharFunction_): Internal.Int2CharFunction;
        identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        (arg0: number): number;
    }
    type Int2FloatFunction_ = Int2FloatFunction;
    class CreativeMotorBlockEntity extends Internal.GeneratingKineticBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        generatedSpeed: Internal.ScrollValueBehaviour;
        static readonly DEFAULT_SPEED: 16;
        static readonly MAX_SPEED: 256;
        computerBehaviour: Internal.AbstractComputerBehaviour;
    }
    type CreativeMotorBlockEntity_ = CreativeMotorBlockEntity;
    class ScheduleItem extends Internal.Item implements Internal.ItemCopyingRecipe$SupportsItemCopying, Internal.MenuProvider {
        constructor(pProperties: Internal.Item$Properties_)
        getDisplayName(): net.minecraft.network.chat.Component;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        handScheduleTo(pStack: Internal.ItemStack_, pPlayer: Internal.Player_, pInteractionTarget: Internal.LivingEntity_, pUsedHand: Internal.InteractionHand_): Internal.InteractionResult;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        createMenu(id: number, inv: Internal.Inventory_, player: Internal.Player_): Internal.AbstractContainerMenu;
        canCopyFromItem(item: Internal.ItemStack_): boolean;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        shouldCloseCurrentScreen(): boolean;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static getSchedule(pStack: Internal.ItemStack_): com.simibubi.create.content.trains.schedule.Schedule;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        canCopyToItem(item: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        createCopy(original: Internal.ItemStack_, count: number): Internal.ItemStack;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get displayName(): net.minecraft.network.chat.Component
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ScheduleItem_ = ScheduleItem;
    class AgriSoilVariant extends Internal.Record {
        constructor(block: Internal.ExtraCodecs$TagOrElementLocation_, states: Internal.List_<string>)
        constructor(block: Internal.ExtraCodecs$TagOrElementLocation_, states: Internal.Optional_<Internal.List<string>>)
        static builder(): Internal.AgriSoilVariant$Builder;
        block(): Internal.ExtraCodecs$TagOrElementLocation;
        states(): Internal.List<string>;
        static readonly CODEC: Internal.Codec<Internal.AgriSoilVariant>;
    }
    type AgriSoilVariant_ = AgriSoilVariant;
    interface BlockColumn {
        abstract getBlock(arg0: number): Internal.BlockState;
        abstract setBlock(arg0: number, arg1: Internal.BlockState_): void;
    }
    type BlockColumn_ = BlockColumn;
    interface VibrationSystem$User {
        calculateTravelTimeInTicks($$0: number): number;
        getListenableEvents(): Internal.TagKey<Internal.GameEvent>;
        isValidVibration($$0: Internal.GameEvent_, $$1: Internal.GameEvent$Context_): boolean;
        onDataChanged(): void;
        abstract onReceiveVibration(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: Internal.GameEvent_, arg3: Internal.Entity_, arg4: Internal.Entity_, arg5: number): void;
        canTriggerAvoidVibration(): boolean;
        abstract canReceiveVibration(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: Internal.GameEvent_, arg3: Internal.GameEvent$Context_): boolean;
        abstract getListenerRadius(): number;
        requiresAdjacentChunksToBeTicking(): boolean;
        abstract getPositionSource(): Internal.PositionSource;
        get listenableEvents(): Internal.TagKey<Internal.GameEvent>
        get listenerRadius(): number
        get positionSource(): Internal.PositionSource
    }
    type VibrationSystem$User_ = VibrationSystem$User;
    abstract class SpruceOption implements dev.lambdaurora.spruceui.util.Nameable {
        constructor(key: string)
        getOptionTooltip(): Internal.Optional<net.minecraft.network.chat.Component>;
        getPrefix(): net.minecraft.network.chat.Component;
        setTooltip(tooltip: net.minecraft.network.chat.Component_): void;
        getName(): string;
        getDisplayText(value: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        abstract createWidget(arg0: dev.lambdaurora.spruceui.Position_, arg1: number): Internal.SpruceWidget;
        get optionTooltip(): Internal.Optional<net.minecraft.network.chat.Component>
        get prefix(): net.minecraft.network.chat.Component
        set tooltip(tooltip: net.minecraft.network.chat.Component_)
        get name(): string
        readonly key: string;
    }
    type SpruceOption_ = SpruceOption;
    class WeightedPressurePlateBlock extends Internal.BasePressurePlateBlock {
        constructor($$0: number, $$1: Internal.BlockBehaviour$Properties_, $$2: Internal.BlockSetType_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly POWER: Internal.IntegerProperty;
    }
    type WeightedPressurePlateBlock_ = WeightedPressurePlateBlock;
    class FabricModConditionalIngredient$Deserializer implements Internal.IngredientDeserializer {
        constructor()
        fromNetwork(buffer: Internal.FriendlyByteBuf_): Internal.Ingredient;
        static init(): void;
        static tryDeserializeJson(object: Internal.JsonObject_): Internal.Ingredient;
        fromJson(object: Internal.JsonObject_): Internal.Ingredient;
        static tryDeserializeNetwork(buf: Internal.FriendlyByteBuf_): Internal.Ingredient;
        static readonly INSTANCE: Internal.FabricModConditionalIngredient$Deserializer;
    }
    type FabricModConditionalIngredient$Deserializer_ = FabricModConditionalIngredient$Deserializer;
    class DecoratedPotBlock extends Internal.BaseEntityBlock implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SHERDS_DYNAMIC_DROP_ID: ResourceLocation;
    }
    type DecoratedPotBlock_ = DecoratedPotBlock;
    abstract class UserPrincipalLookupService {
        abstract lookupPrincipalByName(arg0: string): Internal.UserPrincipal;
        abstract lookupPrincipalByGroupName(arg0: string): Internal.GroupPrincipal;
    }
    type UserPrincipalLookupService_ = UserPrincipalLookupService;
    interface IMixinStairsBlock {
        invokeGetStairShape(state: Internal.BlockState_, worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.StairsShape;
    }
    type IMixinStairsBlock_ = IMixinStairsBlock;
    interface ItemRendererAccessor {
        abstract callRenderModelLists(arg0: Internal.BakedModel_, arg1: Internal.ItemStack_, arg2: number, arg3: number, arg4: Internal.PoseStack_, arg5: Internal.VertexConsumer_): void;
        (arg0: Internal.BakedModel, arg1: Internal.ItemStack, arg2: number, arg3: number, arg4: Internal.PoseStack, arg5: Internal.VertexConsumer): void;
    }
    type ItemRendererAccessor_ = ItemRendererAccessor;
    class ChatListener {
        constructor($$0: Internal.Minecraft_)
        handlePlayerChatMessage($$0: Internal.PlayerChatMessage_, $$1: Internal.GameProfile_, $$2: Internal.ChatType$Bound_): void;
        acceptNextDelayedMessage(): void;
        queueSize(): number;
        handler$bjd000$chat_heads$chatheads$handleAddedSystemMessage(message: net.minecraft.network.chat.Component_, bl: boolean, ci: Internal.CallbackInfo_): void;
        handleDisguisedChatMessage($$0: net.minecraft.network.chat.Component_, $$1: Internal.ChatType$Bound_): void;
        handleSystemMessage($$0: net.minecraft.network.chat.Component_, $$1: boolean): void;
        clearQueue(): void;
        handler$bjd000$chat_heads$chatheads$handleAddedPlayerMessage(bound: Internal.ChatType$Bound_, playerChatMessage: Internal.PlayerChatMessage_, message: net.minecraft.network.chat.Component_, gameProfile: Internal.GameProfile_, bl: boolean, instant: Internal.Instant_, cir: Internal.CallbackInfoReturnable_<any>): void;
        setMessageDelay($$0: number): void;
        tick(): void;
        removeFromDelayedMessageQueue($$0: Internal.MessageSignature_): boolean;
        handler$bjn000$chat_heads$chatheads$handleAddedDisguisedMessage(bound: Internal.ChatType$Bound_, undecoratedMessage: net.minecraft.network.chat.Component_, instant: Internal.Instant_, cir: Internal.CallbackInfoReturnable_<any>): void;
        set messageDelay($$0: number)
    }
    type ChatListener_ = ChatListener;
    class NearestItemSensor extends Internal.Sensor<Internal.Mob> {
        constructor()
        static readonly MAX_DISTANCE_TO_WANTED_ITEM: 32;
    }
    type NearestItemSensor_ = NearestItemSensor;
    class AutoBlastingUpgradeItem extends Internal.UpgradeItemBase<Internal.AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper> implements Internal.IAutoCookingUpgradeItem {
        constructor(autoBlastingUpgradeConfig: Internal.AutoCookingUpgradeConfig_, upgradeTypeLimitConfig: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getAutoCookingUpgradeConfig(): Internal.AutoCookingUpgradeConfig;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getType(): Internal.UpgradeType<Internal.AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper>;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get autoCookingUpgradeConfig(): Internal.AutoCookingUpgradeConfig
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get type(): Internal.UpgradeType<Internal.AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper>
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TYPE: Internal.UpgradeType<Internal.AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper>;
    }
    type AutoBlastingUpgradeItem_ = AutoBlastingUpgradeItem;
    interface MinecraftClientAccessor {
        abstract getConnection(): Internal.Connection;
        get connection(): Internal.Connection
        (): Internal.Connection_;
    }
    type MinecraftClientAccessor_ = MinecraftClientAccessor;
    class ShockingEffect extends Internal.MobEffect {
        constructor()
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
        getRenderer(): Internal.MobEffectRenderer;
        get curativeItems(): Internal.List<Internal.ItemStack>
        get renderer(): Internal.MobEffectRenderer
    }
    type ShockingEffect_ = ShockingEffect;
    class Advancement$Builder {
        build($$0: ResourceLocation_): Internal.Advancement;
        static fromNetwork($$0: Internal.FriendlyByteBuf_): Internal.Advancement$Builder;
        getCriteria(): Internal.Map<string, Internal.Criterion>;
        rewards($$0: Internal.AdvancementRewards$Builder_): this;
        addCriterion($$0: string, $$1: Internal.Criterion_): this;
        parent($$0: ResourceLocation_): this;
        static recipeAdvancement(): Internal.Advancement$Builder;
        display($$0: Internal.ItemLike_, $$1: net.minecraft.network.chat.Component_, $$2: net.minecraft.network.chat.Component_, $$3: ResourceLocation_, $$4: Internal.FrameType_, $$5: boolean, $$6: boolean, $$7: boolean): this;
        parent($$0: Internal.Advancement_): this;
        canBuild($$0: Internal.Function_<ResourceLocation, Internal.Advancement>): boolean;
        save($$0: Internal.Consumer_<Internal.Advancement>, $$1: string): Internal.Advancement;
        serializeToJson(): Internal.JsonObject;
        static fromJson($$0: Internal.JsonObject_, $$1: Internal.DeserializationContext_): Internal.Advancement$Builder;
        static advancement(): Internal.Advancement$Builder;
        addCriterion($$0: string, $$1: Internal.CriterionTriggerInstance_): this;
        requirements($$0: Internal.RequirementsStrategy_): this;
        display($$0: Internal.ItemStack_, $$1: net.minecraft.network.chat.Component_, $$2: net.minecraft.network.chat.Component_, $$3: ResourceLocation_, $$4: Internal.FrameType_, $$5: boolean, $$6: boolean, $$7: boolean): this;
        rewards($$0: Internal.AdvancementRewards_): this;
        requirements($$0: string[][]): this;
        serializeToNetwork($$0: Internal.FriendlyByteBuf_): void;
        display($$0: Internal.DisplayInfo_): this;
        get criteria(): Internal.Map<string, Internal.Criterion>
    }
    type Advancement$Builder_ = Advancement$Builder;
    class WeepingVinesBlock extends Internal.GrowingPlantHeadBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type WeepingVinesBlock_ = WeepingVinesBlock;
    abstract class Raider extends Internal.PatrollingMonster {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        setCurrentRaid($$0: Internal.Raid_): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getCurrentRaid(): Internal.Raid;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        abstract applyRaidBuffs(arg0: number, arg1: boolean): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        canJoinRaid(): boolean;
        attack(hp: number): void;
        setCanJoinRaid($$0: boolean): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        setWave($$0: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        setCelebrating($$0: boolean): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setTicksOutsideRaid($$0: number): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isCelebrating(): boolean;
        getWave(): number;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        abstract getCelebrateSound(): Internal.SoundEvent;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getTicksOutsideRaid(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        hasActiveRaid(): boolean;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set currentRaid($$0: Internal.Raid_)
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get currentRaid(): Internal.Raid
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        set canJoinRaid($$0: boolean)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        set wave($$0: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set celebrating($$0: boolean)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        set ticksOutsideRaid($$0: number)
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get celebrating(): boolean
        get wave(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get celebrateSound(): Internal.SoundEvent
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        get ticksOutsideRaid(): number
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Raider_ = Raider;
    class ItemDriveUpgrade extends Internal.ItemUpgrade {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDriveUpgrade_ = ItemDriveUpgrade;
    interface TaskChainer {
        abstract append(arg0: Internal.TaskChainer$DelayedTask_): void;
        immediate($$0: Internal.Executor_): this;
        (arg0: Internal.TaskChainer$DelayedTask): void;
        readonly LOGGER: Internal.Log4jLogger;
    }
    type TaskChainer_ = TaskChainer;
    interface ItemAccessor {
        port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
    }
    type ItemAccessor_ = ItemAccessor;
    abstract class AbstractGlassBlock extends Internal.HalfTransparentBlock {
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type AbstractGlassBlock_ = AbstractGlassBlock;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor {
    interface AbstractContainerScreenAccessor {
        abstract port_lib$getGuiLeft(): number;
        abstract port_lib$getGuiTop(): number;
    }
    type AbstractContainerScreenAccessor_ = AbstractContainerScreenAccessor;
}
